//
//  SampleDataImporter.swift
//  Do It
//
//  Created by Jim Dovey on 1/4/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import Foundation
import CoreData

func importSampleData(to context: NSManagedObjectContext) throws {
    let dataCenter = DataCenter()

    var listIDs = [Int: TodoItemList]()
    for sample in dataCenter.todoLists {
        let list = TodoItemList.findOrCreateList(
            named: sample.name,
            color: sample.color,
            icon: sample.icon,
            in: context)
        if list.name == "Chores" {
            list.isDefaultList = true
        }
        listIDs[sample.id] = list
    }
    
    for sample in dataCenter.todoItems {
        let list = listIDs[sample.listID]!

        let item = TodoItem.newTodoItem(in: list)
        item.title = sample.title
        item.priority = sample.priority
        item.notes = sample.notes
        item.date = sample.date
        item.complete = sample.complete
        item.manualSortOrder = Int32(list.todoItems?.count ?? 0)
    }
    
    try context.save()
}
